import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ArrayList;

/**
 * @author (Ihr Name) 
 * @version (eine Versionsnummer oder ein Datum)
 */
public class Benutzerschnittstelle extends JFrame
{
    // Satische vordefinierteFarben
    private static final Color FELD_VERAENDERBAR = Color.green;
    private static final Color FELD_NICHT_VERAENDERBAR = Color.black;
    private static final Color FELD_STANDART_HINTERGRUND = Color.white;
    private static final Color FELD_VERAENDERT_HINTERGRUND = Color.lightGray;
    private static final Color FELD_AKTUELLES_FELD = Color.yellow;
    private static final Color PRUEFEN_BUTTON_RICHTIG = Color.green;
    private static final Color PRUEFEN_BUTTON_FALSCH = Color.red;

    private boolean initialisiert;
    private Steuerung steuerung;
    private Sudoku sudoku;

    private Color aktuelleHintergrundfarbe;

    private HashMap <JButton, Feld> hashMapButtonFeld;
    private HashMap <JButton, Integer> hashMapButtonBenutzereingabe;

    private JButton beenden, pruefen;
    private JButton [] [] feld1;


    private JButton aktuellesFeld;

    private JLabel labelgewonnen;

    private JMenuBar menuBar;

    public Benutzerschnittstelle(Steuerung pSteuerung, Sudoku pSudoku)
    {
        this.steuerung = pSteuerung;
        this.sudoku = pSudoku;
        initialisiert = false;
        erstelleBildschirm(); 

    }

    //Methoden von den ActionListenern aufgerufen
    private void ladeSudokuBefehl(int pNummer)
    {
        System.out.println("Sudoku " + pNummer);
        //         steuerung.initialisiereSudoku(pNummer);
    }

    private void hellerBefehl()
    {
        aktuelleHintergrundfarbe = FELD_STANDART_HINTERGRUND;
        if (initialisiert == true)
        {
            felderAktualisieren();
        }
    }

    private void dunklerBefehl()
    {
        aktuelleHintergrundfarbe = FELD_VERAENDERT_HINTERGRUND;
        if (initialisiert == true)
        {
            felderAktualisieren();
        }
    }

    private void zeigeVersionBefehl()
    {
        JOptionPane.showMessageDialog(null, 
            "Sudoku\n" + steuerung.gibVersion(),
            "Info zu Sudoku", 
            JOptionPane.INFORMATION_MESSAGE);
    }

    private void zeigeAnleitungBefehl()
    {
        JOptionPane.showMessageDialog(null, 
            "Spielanleitung: Waehl dir links ein Sudoku.\n Dann kannst du ein Feld mit der Maus auswaehlen und eine Zahl eingeben.\n Mit pruefen kannst du sehen, ob du richtig bist. gruen = richtig. rot = falsch",
            "", 
            JOptionPane.INFORMATION_MESSAGE);
    }

    private void beendenBefehl()
    {
        System.exit(0);
    }

    private void pruefenBefehl()
    {
        //         if (steuerung.istSudokuInitialisiert() == true)
        //         {
        //             boolean tmp = steuerung.testeObSudokuKorrektIst();
        //             if (tmp)
        //             {
        //                 pruefenButton.setBackground (PRUEFEN_BUTTON_RICHTIG);
        //             }
        //             else
        //             {
        //                 pruefenButton.setBackground (PRUEFEN_BUTTON_FALSCH);
        //             }
        //         }
    }

    private void benutzerEingabeFeldWirdGewaehltBefehl(int pWertX, int pWertY)
    {
        if ((pWertX >= 0 && pWertX < 9) && (pWertY >= 0 && pWertY < 9))
        {

        }
    }

    private void benutzerEingabeZahlWirdAufFeldAngewendet(int pWert)
    {
        if (pWert >= 0 && pWert <= 9)
        {

        }
    }

    // BildschirmkomponenteErzeugen
    private void erstelleBildschirm()
    {
        this.setName("Sudoku");
        this.setSize(900, 700);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        this.setLayout(null);

        
        //Layout

        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());

        JPanel jPanelNorth = new JPanel();
        contentPane.add(jPanelNorth, BorderLayout.NORTH);

        JPanel jPanelSouth = new JPanel();
        contentPane.add(jPanelSouth, BorderLayout.SOUTH);
        
        erstelleAnsichtWest ();

        JPanel jPanelEast = new JPanel();
        contentPane.add(jPanelEast, BorderLayout.EAST);


        erstelleAnsichtCenter ();
        JPanel jPanelCenter = new JPanel();
        contentPane.add(jPanelCenter, BorderLayout.CENTER);

        //Menu
        erstelleMenue();
        
        //Buttons
        pruefen = new JButton("Pruefen");
        pruefen.setBounds(160, 50, 120, 20);
        add(pruefen);
        pruefen.addActionListener(listenerButtonsPruefen);

        labelgewonnen = new JLabel("");
        labelgewonnen.setBounds(300, 20, 120, 20);
        add(labelgewonnen);



        // Das Fenster in der Mitte des Bildschirms platzieren und anzeigen
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width/2 - this.getWidth()/2, d.height/2 - this.getHeight()/2);
        this.setVisible(true);
    }

    private void erstelleMenue()
    {
        menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);

        JMenu menuSudokuAuswahl = new JMenu("Sodoku");
        menuBar.add(menuSudokuAuswahl);

        JMenuItem sudoku1MenuItem = new JMenuItem("Sudoku 1");
        sudoku1MenuItem.addActionListener(listenerSudoku1MenuItem);
        menuSudokuAuswahl.add(sudoku1MenuItem);

        JMenuItem sudoku2MenuItem = new JMenuItem("Sudoku 2");
        sudoku2MenuItem.addActionListener(listenerSudoku2MenuItem);
        menuSudokuAuswahl.add(sudoku2MenuItem);

        JMenuItem sudoku3MenuItem = new JMenuItem("Sudoku 3");
        sudoku3MenuItem.addActionListener(listenerSudoku3MenuItem);
        menuSudokuAuswahl.add(sudoku3MenuItem);

        menuSudokuAuswahl.addSeparator();

        JMenuItem beendenMenuItem = new JMenuItem("Beenden");
        beendenMenuItem.addActionListener(listenerBeendenMenuItem);
        menuSudokuAuswahl.add(beendenMenuItem);

        JMenu menuHelligkeit = new JMenu("Helligkeit");
        menuBar.add(menuHelligkeit);

        JMenuItem menuItemHeller = new JMenuItem("Heller");
        menuHelligkeit.add(menuItemHeller);
        menuItemHeller.addActionListener(listenerMenuItemHeller);

        JMenuItem menuItemDunkler = new JMenuItem("Dunkler");
        menuHelligkeit.add(menuItemDunkler);
        menuItemDunkler.addActionListener(listenerMenuItemDunkler);

        JMenu menuHilfe = new JMenu("Hilfe");
        menuBar.add(menuHilfe);

        JMenuItem menuItemEintrag1 = new JMenuItem("Anleitung");
        menuHilfe.add(menuItemEintrag1);
        menuItemEintrag1.addActionListener(listenerMenuItemEintrag1);

        JMenuItem menuItemVersion = new JMenuItem("Version");
        menuHilfe.add(menuItemVersion);
        menuItemVersion.addActionListener(listenerMenuItemVersion);
    }

    private void erstelleAnsichtNord ()
    {

    }

    private void erstelleAnsichtWest ()
    {
        JPanel jPanelWest = new JPanel();
        this.getContentPane().add(jPanelWest, BorderLayout.WEST);
        jPanelWest.setLayout(new FlowLayout());
        
        JPanel benutzerKnoepfe = new JPanel();
        benutzerKnoepfe.setLayout(new GridLayout(5, 2));
        jPanelWest.add(benutzerKnoepfe);
        
        hashMapButtonBenutzereingabe = new HashMap <JButton, Integer> ();
        for (int i = 0; i < 10; i++)
        {
            JButton tmp = new JButton("" + i);
            benutzerKnoepfe.add(tmp);
            tmp.addActionListener(listenerButtonsBenutzereingabe);
            hashMapButtonBenutzereingabe.put(tmp, new Integer(i));  
        }
    }
    
    private void erstelleAnsichtCenter ()
    {
               
    }


    private void felderAktualisieren()
    {
        if (initialisiert = true)
        {

            int maximalY = sudoku.gibSeitenLaenge();
            int maximalX = sudoku.gibSeitenLaenge();

            int positionY = 0;
            int positionX = 0;  

            while (positionY < maximalY)
            {
                positionX = 0;
                while (positionX < maximalX)
                {
                    JButton tmp = null;
                    tmp = feld1 [positionY] [positionX];
                    Feld felder = hashMapButtonFeld.get(tmp);

                    if (felder.getZahl() == 0)
                    {

                        tmp.setText("");
                    }
                    else if (felder.getZahl() >= 1 && felder.getZahl() <= 9)
                    {
                        tmp.setText("" + felder.getZahl());
                    }
                    else
                    {
                        System.out.println("Fehler buttonsRichtigeZahlenGeben(), else");
                    }
                    tmp.setBackground (FELD_STANDART_HINTERGRUND);

                    if (aktuellesFeld != null)
                    {
                        aktuellesFeld.setBackground (FELD_AKTUELLES_FELD);
                    }

                    positionX ++;
                }
                positionY ++;
            }

            if (steuerung.spielIstGewonnen() ==  true)
            {
                labelgewonnen.setText("Du Hast Gewonnen");
            }
        }

    }

    private void erzeugeDasSpielfeld()
    {
        
        JPanel jPanelCenter = new JPanel();
        this.getContentPane().add(jPanelCenter, BorderLayout.CENTER);
        
        
        
        feld1 = null;
        int maximalY = sudoku.gibSeitenLaenge();
        int maximalX = sudoku.gibSeitenLaenge();
        feld1 = new JButton [maximalY]  [maximalX];
        int positionY = 0;
        int positionX = 0;
        hashMapButtonFeld = null;
        hashMapButtonFeld = new HashMap<JButton, Feld> ();
        int sudokuBlock3 = 10;

        while (positionY < maximalY)
        {
            positionX = 0;
            int sudokuBlock3RelativIntY = positionY / 3;
            while (positionX < maximalX)
            {
                JButton tmp = new JButton ("x=" + positionX+1 + "   y=" + positionY+1);
                feld1 [positionY] [positionX] =  tmp;

                int sudokuBlock3RelativIntX = positionX / 3;

                tmp.setBounds(250 + (sudokuBlock3 * sudokuBlock3RelativIntX) + ((positionX + 1) * 52), 20 + (sudokuBlock3 * sudokuBlock3RelativIntY) + ((positionY + 1) * 52), 50, 50);

                hashMapButtonFeld.put(tmp, sudoku.gibFeld(positionX, positionY));
                if (sudoku.veraenderbar(positionX, positionY) == true)
                {
                    tmp.setForeground(FELD_VERAENDERBAR);
                }
                else if (sudoku.veraenderbar(positionX, positionY) == false)
                {
                    tmp.setForeground(FELD_NICHT_VERAENDERBAR);
                }

                jPanelCenter.add(tmp);
                tmp.addActionListener(listenerButtonsSpielfeld);

                positionX ++;

            }
            positionY ++;

        }
    }

    

    public void setzeSudoku(Sudoku pSudoku)
    {
        this.sudoku = pSudoku;
    }

    private final ActionListener listenerBeendenMenuItem = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                beendenBefehl();
            }
        };

    private final ActionListener listenerSudoku1MenuItem = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (initialisiert == false)
                {
                    steuerung.formation1();
                    erzeugeDasSpielfeld();
                    felderAktualisieren();
                    initialisiert = true;
                }
            }
        };

    private final ActionListener listenerSudoku2MenuItem = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (initialisiert == false)
                {
                    steuerung.formation2();
                    erzeugeDasSpielfeld();
                    felderAktualisieren();
                    initialisiert = true;
                }
            }
        };

    private final ActionListener listenerSudoku3MenuItem = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (initialisiert == false)
                {
                    steuerung.formation3();
                    erzeugeDasSpielfeld();
                    felderAktualisieren();
                    initialisiert = true;
                }
            }
        };

    private final ActionListener listenerButtonsPruefen = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (sudoku.besitztFeld() == true)
                {

                    boolean tmp = steuerung.testeObSudokuKorrektIst();
                    if (tmp)
                    {
                        pruefen.setBackground (Color.green);
                    }
                    else
                    {
                        pruefen.setBackground (Color.red);
                    }
                }
            }
        };

    private final ActionListener listenerButtonsSpielfeld = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (sudoku.besitztFeld() == true)
                {
                    aktuellesFeld = (JButton) e.getSource();

                    felderAktualisieren();

                }
            }
        };

    private final ActionListener listenerButtonsBenutzereingabe = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (sudoku.besitztFeld() == true)
                {
                    JButton tmp = (JButton) e.getSource();
                    int wert = hashMapButtonBenutzereingabe.get(tmp).intValue();
                    hashMapButtonFeld.get(aktuellesFeld).setzeZahl(wert);
                    felderAktualisieren();
                }
            }
        };

    private final ActionListener listenerMenuItemEintrag1 = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                zeigeAnleitungBefehl();
            }
        };

    private final ActionListener listenerMenuItemVersion = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                zeigeVersionBefehl();
            }
        };

    private final ActionListener listenerMenuItemHeller = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                hellerBefehl();
            }
        };

    private final ActionListener listenerMenuItemDunkler = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                dunklerBefehl();
            }
        };

}